﻿<%@ Page Language="c#" CodePage="1200" %>

<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Waluty" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Business.App" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<script runat="server">

    public class DuplikatContext : ContextBase {

        public DuplikatContext( Context cx )
            : base( cx ) {
        }

        bool duplikat = true;

        [Caption( "Duplikat" )]
        public bool Duplikat {
            get { return duplikat; }
            set { duplikat = value; }
        }

    }

    static readonly string divider = "<pre>" + new string( '-', 80 ) + "</pre>";
    static readonly string longdivider = "<small><pre>" + new string( '-', 130 ) + "</pre></small>";

    void OnContextLoading( Object sender, EventArgs args ) {
        DokumentHandlowy d = (DokumentHandlowy)dc[typeof( DokumentHandlowy )];
        if( d == null ) return;

        if( d.Stan != StanDokumentuHandlowego.Bufor ) {
            if( !dc.Context.Contains( typeof( ParametryWydrukuDokumentu.Zatwierdzany ) ) )
                dc.AddRequiredType( typeof( DuplikatContext ) );
        }
    }

    bool duplikat = false;
    DokumentHandlowy dokument;
    CoreModule core;

    void OnContextLoad( Object sender, EventArgs args ) {
        ///////////////////////////////////////////////
        // Inicjacja pól
        //
        if( dc.Context.Contains( typeof( DuplikatContext ) ) )
            duplikat = ( (DuplikatContext)dc[typeof( DuplikatContext )] ).Duplikat;

        dokument = (DokumentHandlowy)dc[typeof( DokumentHandlowy )];
        core = CoreModule.GetInstance( dc );
		DataLabel6.EditValue = dokument.LiczonaOd == SposobLiczeniaVAT.OdNetto ? dokument.Suma.NettoCy : dokument.Suma.BruttoCy;
		
        // TASK: 5221. [7.2] /sbm		
        dc.AdditionalFooterInfo = dokument.Definicja.InformacjeKRS;

        divider1.EditValue = divider;
        divider5.EditValue = divider;

        divider6.EditValue = longdivider;

        //Formatujemy informacj o podmiocie

        if( dokument.Kontrahent != null ) {
            
            DataLabel14.EditValue = multiLineEncode( dokument.DaneKontrahenta.NazwaFormatowana );
            DataLabel15.EditValue = HttpUtility.HtmlEncode( dokument.DaneKontrahenta.Adres.Linia1 );
            DataLabel16.EditValue = HttpUtility.HtmlEncode( dokument.DaneKontrahenta.Adres.Linia2 );

            DataLabel18.EditValue = multiLineEncode( dokument.DaneOdbiorcy.NazwaFormatowana );
            DataLabel19.EditValue = HttpUtility.HtmlEncode( dokument.DaneOdbiorcy.Adres.Linia1 );
            DataLabel20.EditValue = HttpUtility.HtmlEncode( dokument.DaneOdbiorcy.Adres.Linia2 );


            if( dokument.Wydruk.JestOdbiorcaMiejsceDostawy ) {
                this._colOdbiorcaMiejsceDostawyNazwa.EditValue = multiLineEncode( dokument.OdbiorcaMiejsceDostawy.Nazwa );
                this._colOdbiorcaMiejsceDostawyAdresLinia1.EditValue = HttpUtility.HtmlEncode( dokument.OdbiorcaMiejsceDostawy.Adres.Linia1 );
                this._colOdbiorcaMiejsceDostawyAdresLinia2.EditValue = HttpUtility.HtmlEncode( dokument.OdbiorcaMiejsceDostawy.Adres.Linia2 );

                string ktos = dokument.Definicja.DostawcaOdbiorca;
                kto2.EditValue = ktos + ":" + new string( '-', 81 - ktos.Length );

                if( dokument.Wydruk.JestOdbiorca )
                    ktos = "Kontrahent";
                else
                    ktos = dokument.Definicja.DostawcaOdbiorca;

                kto.EditValue = ktos;
            }

            if (dokument.Definicja.JestKWPZ)
                TextGrid1.Visible = false;
            else
                TextGridKWPZ.Visible = false;


        }
        
        //Skadamy opis do dokumentu
        string opis = "";
        if (dokument.Opis != "")
            opis += "<br>" + dokument.Opis;
        if (dokument.Wydruk.OpisWydruku != "")
        {
            if (opis != "")
                opis += "<br>";
            opis += "<br>" + dokument.Wydruk.OpisWydruku;
        }
        Opis.EditValue = opis;

        //Formatujemy stopk dokumentu
        Stopka.EditValue =
        "<pre>" +
        Center(dokument.Wydruk.UprawnionyDoWystawienia.FullName, 40) + "| " + Center(dokument.Osoba, 38) + "<br>" +
        Left("", 40) + "|<br>" +
        Left("", 40) + "|<br>" +
        Center("..............................", 40) + "| " + Center("..............................", 38) + "<br>" +
        Center("Podpis osoby uprawnionej", 40) + "|  " + Center("Podpis osoby upoważnionej", 38) + "<br>" +
        Center("do wystawienia dokumentu", 40) + "|  " + Center("do otrzymania dokumentu", 38) +
        "</pre>";

        switch (dokument.LiczonaOd)
        {
            case SposobLiczeniaVAT.OdBrutto:
            case SposobLiczeniaVAT.OdBruttoMinusNetto:
                {
                    CenaColumn.Caption += " brutto";
                    WartoscColumn.Caption += " brutto";
                    break;
                }
            case SposobLiczeniaVAT.OdNetto:
                {
                    CenaColumn.Caption += " netto";
                    WartoscColumn.Caption += " netto";
                    break;
                }

        }        
        
        init();
        Grid1_RabatP.Visible = Grid1_CenaPrzedRabatem.Visible = dokument.JestRabat && dokument.Definicja.DrukowanieCenyIRabatu && !dokument.Definicja.CenaWartosc0;
    }

    string multiLineEncode(string s) {
        string[] t = s.Split('\n');
        for (int i = t.Length; --i >= 0; )
            t[i] = HttpUtility.HtmlEncode(t[i]);
        return string.Join("<br>&nbsp;&nbsp;&nbsp;&nbsp;", t);
    }

    int lc;
    void init() {

        //resetujemy licznik pozycji
        lc = 0;

        //Formatujemy nagwek dokumentu.
        //Moe by za kadym razem inny

        string dup = duplikat ? "<b>Duplikat</b>" : "";

        header.EditValue =
            "<pre>" +
            Left(core.Config.Firma.Pieczątka.Nazwa, 40) + "| " + Left(dokument.Definicja.TytulWydruku, 30) + "<br>" +
            Left(core.Config.Firma.AdresSiedziby.Linia1, 40) + "| <b>" + dokument.Numer + "   " + dup + " " + "</b><br>" +
            Left(core.Config.Firma.AdresSiedziby.Linia2, 40) + "| <small>Data i miejsce wystawienia: " + dokument.Data + ", " + (dokument.Wydruk.JestOddzial ? dokument.Wydruk.PieczatkaOddziału.Adres.Miejscowosc : core.Config.Firma.AdresSiedziby.Miejscowosc) + "</small><br>" +
            Left("NIP: " + core.Config.Firma.Pieczątka.EuVAT, 40) + "| <small>Data operacji: " + dokument.DataOperacji + "</small>" +
            (!duplikat ? "" : "<br>" + Left("", 40) + "| <small>Data wystawienia duplikatu: " + Date.Today + "</small>") +
            "</pre>";

    }


    static string Center(object value, int len) {
        string ss = value.ToString();
        if (ss.Length >= len)
            return ss.Substring(0, len);
        int delta = len - ss.Length;
        int a = delta / 2;
        return ss.PadRight(ss.Length + a).PadLeft(len);
    }

    static string Left(object value, int len) {
        string ss = value.ToString();
        if (ss.Length > len)
            return ss.Substring(0, len);
        return ss.PadRight(len);
    }

    static string Right(object value, int len) {
        string ss = value.ToString();
        if (ss.Length > len)
            return ss.Substring(0, len);
        return ss.PadLeft(len);
    }

    static string Clip(object value, int len) {
        string ss = value.ToString();
        if (ss.Length > len)
            return ss.Substring(0, len);
        return ss;
    }

    bool przedKorektą = true;
    void Grid_OnBeforeGroup( object sender, GroupEventArgs args ) {
      if( args.GroupLine == "Korekta" ) {
        przedKorektą = false;
      }
    }

    void Grid_OnBeforeRow( object sender, RowEventArgs args ) {
      PozycjaDokHandlowego poz = (PozycjaDokHandlowego)args.Row;

      if( !poz.Korekta || przedKorektą ) {
        IloscColumn.EditValue = poz.Ilosc.Value;
        WartoscColumn.EditValue = poz.WartoscCy;
      } else {
        IloscColumn.EditValue = poz.ZmianaIlości.Value;
        WartoscColumn.EditValue = poz.ZmianaWartościCy;
      }
    }
    
</script>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title></title>
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR" />
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form id="Sprzeda" method="post" runat="server">
    <ea:datacontext id="dc" runat="server" typename="Soneta.Handel.DokumentHandlowy,Soneta.Handel"
        oncontextload="OnContextLoad" oncontextloading="OnContextLoading"></ea:datacontext>
    
        
    <ea:datalabel id="header" runat="server"></ea:datalabel>
    <br />
    <ea:datalabel id="divider1" runat="server"></ea:datalabel>
    <br />

    <% if( dokument.DokumentHandlowyNumer != "" ) { %>
    &nbsp;&nbsp;&nbsp;&nbsp;Dokument handlowy:
    <ea:datalabel runat="server" bold="False" datamember="DokumentHandlowyNumer" id="Datalabel1"></ea:datalabel>
    z dnia:
    <ea:datalabel runat="server" bold="False" datamember="DokumentHandlowyData" id="Datalabel2"></ea:datalabel>
    <br />
    <% } %>
    <% if( dokument.Magazyn != null ) { %>
    <% if( dokument.MagazynDo != null ) { %>
    &nbsp;&nbsp;&nbsp;&nbsp;Z magazynu:
    <ea:datalabel runat="server" bold="False" datamember="Magazyn" id="Datalabel3"></ea:datalabel>
    do magazynu:
    <ea:datalabel runat="server" bold="False" datamember="MagazynDo" id="Datalabel4"></ea:datalabel>
    <% } else { %>
    &nbsp;&nbsp;&nbsp;&nbsp;Magazyn:
    <ea:datalabel runat="server" bold="False" datamember="Magazyn" id="Datalabel5"></ea:datalabel>
    <% } %>
    <br />
    <% } %>

    <table cellspacing="0" width="100%">
        <tr>
            <td align="left" valign="top">
                <br />
                <!-- Oddział firmy -->
                <ea:section id="OddzialFirmy" runat="server" datamember="Wydruk.JestOddzial">
        <em style="text-decoration: none;">Oddział:</em><br />
        &nbsp;&nbsp;&nbsp;&nbsp;<ea:DataLabel ID="DataLabel242" runat="server" EncodeHTML="True" Bold="true" DataMember="Wydruk.Oddział.Nazwa"></ea:DataLabel><br />
        &nbsp;&nbsp;&nbsp;&nbsp;<ea:DataLabel ID="DataLabel244" runat="server" EncodeHTML="True" Bold="true" DataMember="Wydruk.Oddział.Adres.Linia1"></ea:DataLabel><br />
        &nbsp;&nbsp;&nbsp;&nbsp;<ea:DataLabel ID="DataLabel245" runat="server" EncodeHTML="True" Bold="true" DataMember="Wydruk.Oddział.Adres.Linia2"></ea:DataLabel><br />
        </ea:section>
                <!-- Oddział firmy -->
            </td>
            <td align="left" valign="top">
                <br />
                <i>
                    <ea:datalabel id="kto" runat="server" bold="False"></ea:datalabel>
                </i>
                <br>
                &nbsp;&nbsp;&nbsp;&nbsp;<ea:datalabel id="DataLabel14" runat="server"></ea:datalabel><br>
                &nbsp;&nbsp;&nbsp;&nbsp;<ea:datalabel id="DataLabel15" runat="server"></ea:datalabel><br>
                &nbsp;&nbsp;&nbsp;&nbsp;<ea:datalabel id="DataLabel16" runat="server"></ea:datalabel><br>
                &nbsp;&nbsp;&nbsp;&nbsp;NIP:
                <ea:datalabel id="DataLabel17" runat="server" datamember="DaneKontrahenta.EuVAT"></ea:datalabel>
                <br>
                <% if( dokument.Wydruk.JestOdbiorca ) { %>
                <i>
                    <ea:datalabel id="kto2" runat="server" bold="False"></ea:datalabel>
                </i>
                <br>
                &nbsp;&nbsp;&nbsp;&nbsp;<ea:datalabel id="DataLabel18" runat="server"></ea:datalabel><br>
                &nbsp;&nbsp;&nbsp;&nbsp;<ea:datalabel id="DataLabel19" runat="server"></ea:datalabel><br>
                &nbsp;&nbsp;&nbsp;&nbsp;<ea:datalabel id="DataLabel20" runat="server"></ea:datalabel><br>
                &nbsp;&nbsp;&nbsp;&nbsp;NIP:
                <ea:datalabel id="DataLabel21" runat="server" datamember="DaneOdbiorcy.EuVAT"></ea:datalabel>
                <br>
                <% } %>
                <% if( dokument.Wydruk.JestOdbiorcaMiejsceDostawy ) { %>
                <i>Miejsce dostawy:</i><br />
                &nbsp;&nbsp;&nbsp;&nbsp;<ea:datalabel id="_colOdbiorcaMiejsceDostawyNazwa" runat="server"></ea:datalabel><br />
                &nbsp;&nbsp;&nbsp;&nbsp;<ea:datalabel id="_colOdbiorcaMiejsceDostawyAdresLinia1"
                    runat="server"></ea:datalabel><br />
                &nbsp;&nbsp;&nbsp;&nbsp;<ea:datalabel id="_colOdbiorcaMiejsceDostawyAdresLinia2"
                    runat="server"></ea:datalabel><br />
                <% } %>
            </td>
        </tr>
    </table>

    <small>
        <ea:textgrid id="TextGrid1" runat="server" rowtypename="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel"
            datamember="Wydruk.PozycjeRazem" font-size="Small" groupdata0="Workers.WydrukPozycji.SekcjaDokumentuMag"
            groupline="{0}" OnBeforeGroup="Grid_OnBeforeGroup" OnBeforeRow="Grid_OnBeforeRow">
            <Columns>
                <ea:GridColumn runat="server" Align="Right" Caption="Lp." DataMember="Lp" Width="3"> </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="Kod Towaru" DataMember="Towar.Kod" EncodeHTML="True" Width="15" Align="Left"> </ea:GridColumn>
                <ea:GridColumn runat="server" Align="Left" Caption="Nazwa Towaru" DataMember="NazwaPierwszaLinia" Width="38" Total="Info" EncodeHTML="True"> </ea:GridColumn>
                <ea:GridColumn ID="Grid1_CenaPrzedRabatem" runat="server"  DataMember="Cena" Width="7" Caption="Cena przed rabatem" Align="Right"> </ea:GridColumn>
                <ea:GridColumn ID="Grid1_RabatP" runat="server"  DataMember="Rabat" Width="7" Caption="Rabat %" Align="Right"> </ea:GridColumn>
                <ea:GridColumn runat="server" ID="CenaColumn" Caption="Cena" DataMember="CenaPoRabacie" Width="15" Align="Right"> </ea:GridColumn>
                <ea:GridColumn runat="server" Align="Right" Caption="Ilość" ID="IloscColumn" Width="7" RightBorder="None" Format="{0:n}"> </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="jm." DataMember="Ilosc.Symbol" Width="6" Align="Right"> </ea:GridColumn>
                <ea:GridColumn runat="server" ID="WartoscColumn" Caption="Wartość" Width="15" Align="Right" Format="{0:n}" Total="Sum" SumFontBold="False"> </ea:GridColumn>
            </Columns>
          </ea:textgrid>
        
        <!-- KWPZ -->
        <ea:textgrid id="TextGridKWPZ" runat="server" rowtypename="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel"
                     datamember="Wydruk.PozycjeRazem" font-size="Small" groupdata0="Workers.WydrukPozycji.SekcjaDokumentuMag"
                     groupline="{0}" OnBeforeGroup="Grid_OnBeforeGroup" OnBeforeRow="Grid_OnBeforeRow">
            <Columns>
                <ea:GridColumn runat="server" Align="Right" Caption="Lp." DataMember="Lp" Width="3"> </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="Kod Towaru" DataMember="Towar.Kod" EncodeHTML="True" Width="15" Align="Left"> </ea:GridColumn>
                <ea:GridColumn runat="server" Align="Left" Caption="Nazwa Towaru" DataMember="NazwaPierwszaLinia" Width="38" Total="Info" EncodeHTML="True"> </ea:GridColumn>
                <ea:GridColumn runat="server" Align="Right" Caption="Ilość" DataMember="Ilosc.Value" ID="GridColumn1" Width="7" RightBorder="None" Format="{0:n}"> </ea:GridColumn>
                <ea:GridColumn runat="server" Caption="jm." DataMember="Ilosc.Symbol" Width="6" Align="Right"> </ea:GridColumn>
                <ea:GridColumn runat="server" ID="ZmianaKosztuWlasnegoCol" Caption="Zmiana kosztu własnego" Width="27" Align="Right" Format="{0:n}" DataMember="WartośćWCenieZakupu" Total="Sum" SumFontBold="False"> </ea:GridColumn>
            </Columns>
        </ea:textgrid>
    </small>        

   <ea:Section ID="Section1" runat="server" DataMember="Korekta" Pagination="True">
      <small style="text-align: right">
            Wartość korekty: <ea:DataLabel ID="DataLabel6" runat="server" Bold="false"
            format="{0,98}" nonbreakspace="True"></ea:DataLabel>
      </small>
      <br />
    </ea:Section>
    
    <ea:section runat="server" Pagination="True">
        <small>Podsumowanie ilości: &nbsp;
            <ea:datalabel id="DataLabel7" runat="server" bold="False" datamember="Wydruk.PodsumowanieIlości" format="{0,92}" nonbreakspace="True"></ea:datalabel>
        </small>
        <br />
        <ea:datalabel id="divider6" runat="server" bold="False"></ea:datalabel>
        <br />
    </ea:section>

    <ea:section id="sectionNumeryNadrzednych" runat="server" datamember="Wydruk.CzyDrukowacNumeryPowiazanych"
      Pagination="True" widthchar="80">
      <em>Dokumenty powiązane:</em>
      <div>
        <ea:DataLabel ID="labelNumeryNadrzednych" runat="server" DataMember="Wydruk.NumeryNadrzędnZK"
          Bold="False" WidthChar="60">
        </ea:DataLabel>
        <ea:DataLabel ID="labelNumeryPodrzednych" runat="server" DataMember="Wydruk.NumeryPodrzędneBK"
          Bold="False" WidthChar="60">
        </ea:DataLabel>
      </div>
    </ea:section>
   
    <ea:Section runat="server" Pagination="True">
    <ea:datalabel id="divider16" runat="server" bold="False"></ea:datalabel>
    <br />
    <ea:datalabel id="Opis" runat="server" bold="False"></ea:datalabel>
    <br />
    <ea:datalabel id="divider5" runat="server" bold="False"></ea:datalabel>
    <br />
    <ea:datalabel id="Stopka" runat="server" bold="False"></ea:datalabel>
    <br />
    </ea:Section>     

    <cc1:ReportFooter ID="ReportFooter1" runat="server" TheEnd="False">
    </cc1:ReportFooter>

    </form>
</body>
</html>

